#ifndef NASCCL_Merge_Cpp
#define NASCCL_Merge_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    The Merge function is used to merge 6 values into one single usable value.
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "NASCCL.H"
#include "sBoxes.H"
#include "Math.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Merge All 6 Values With All 6 Rounds. Return The Calculated Result.
NASCCLByte Merge(NASCCLByte Value1, NASCCLByte Value2, NASCCLByte Value3, NASCCLByte Value4, NASCCLByte Value5, NASCCLByte Value6)
{
    NASCCLByte ReturnValue = 0;
    NASCCLByte RoundValue  = 0;

    NASCCLByte RoundValue1 = 0;
    NASCCLByte RoundValue2 = 0;
    NASCCLByte RoundValue3 = 0;
    NASCCLByte RoundValue4 = 0;
    NASCCLByte RoundValue5 = 0;
    NASCCLByte RoundValue6 = 0;

    RoundValue  = ( (Value1 + Value4) + (Value2 + Value5) + (Value3 + Value6) );

    RoundValue1 = Round1(Value6, RoundValue);
    RoundValue2 = Round2(Value5, RoundValue);
    RoundValue3 = Round3(Value4, RoundValue);
    RoundValue4 = Round4(Value3, RoundValue);
    RoundValue5 = Round5(Value2, RoundValue);
    RoundValue6 = Round6(Value1, RoundValue);

    ReturnValue = ( (RoundValue6 + RoundValue3) + (RoundValue5 + RoundValue2) + (RoundValue4 + RoundValue1) );

    return ReturnValue;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

